#!/bin/bash
MODEL_PATH=$1
gpu_list="${CUDA_VISIBLE_DEVICES:-0}"
IFS=',' read -ra GPULIST <<< "$gpu_list"

CHUNKS=${#GPULIST[@]}

# CKPT="llava-v1.5-13b"
SPLIT="llava_vqav2_mscoco_test2015"

for IDX in $(seq 0 $((CHUNKS-1))); do
    CUDA_VISIBLE_DEVICES=${GPULIST[$IDX]} python -m llava.eval.model_vqa_loader \
        --model-path ${MODEL_PATH} \
        --question-file <OUTPUT_FOLDER>/llava/eval/vqav2/$SPLIT.jsonl \
        --image-folder <DATA_FOLDER>/coco/test2015 \
        --answers-file ${MODEL_PATH}/vqav2/answers/$SPLIT/${CHUNKS}_${IDX}.jsonl \
        --num-chunks $CHUNKS \
        --chunk-idx $IDX \
        --temperature 0 \
        --conv-mode vicuna_v1 &
done

wait

output_file=${MODEL_PATH}/vqav2/answers/$SPLIT/merge.jsonl

Clear out the output file if it exists.
> "$output_file"

python -m llava.eval.utils merge_files \
    --input_folder ${MODEL_PATH}/vqav2/answers/$SPLIT \
    --output_file "$output_file" \
    --num_chunks $CHUNKS

dest_file=${MODEL_PATH}/vqav2/answers/$SPLIT/submission.json

python scripts/convert_vqav2_for_submission.py --src $output_file  --dst $dest_file --ann <OUTPUT_FOLDER>/llava/eval/vqav2/$SPLIT.jsonl



# python scripts/convert_vqav2_for_submission.py --split $SPLIT --ckpt $CKPT

